% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remiod.R
\name{remiod}
\alias{remiod}
\title{Reference-Based Multiple Imputation for Ordinal/Binary Response}
\usage{
remiod(formula, data, trtvar, refcats = NULL, family = NULL,
  method = "MAR", delta = 0, algorithm = c("tang_seq", "jags"),
  rinv = 1e-04, scheme = 2, model_order = NULL, models = NULL,
  ord_cov_dummy = TRUE, n.chains = 2, n.adapt = 100, n.iter = 1000,
  thin = 2, start = NULL, end = NULL, seed = 1234,
  exclude_chains = NULL, subset = NULL, include = FALSE, mess = TRUE,
  warn = FALSE, progress.bar = TRUE, ...)
}
\arguments{
\item{formula}{a two sided model formula (see \code{\link[stats]{formula}})
or a list of such formulas; (more details below).}

\item{data}{a \code{data.frame} containing the original data
(more details below)}

\item{trtvar}{the name of treatment variable. When necessary, its reference category,
i.e. control arm, can be set in \code{refcats} argument.}

\item{refcats}{optional; either one of \code{"first"}, \code{"last"},
\code{"largest"} (which sets the category for all categorical
variables) or a named list specifying which category should
be used as reference category per categorical variable.
Options are the category label, the category number,
or one of "first" (the first category),
"last" (the last category) or "largest" (chooses the category
with the most observations).
Default is "first". If reference categories are specified for
a subset of the categorical variables the default will be
used for the remaining variables.
(See also \code{\link[JointAI]{set_refcat}})}

\item{family}{only for \code{glm_imp} and \code{glmm_imp}/\code{glmer_imp}:
a description of the distribution and link function to
be used in the model. This can be a character string naming a
family function, a family function or the result of a call to
a family function. (For more details see below and
\code{\link[stats]{family}}.)}

\item{method}{a method for obtaining multiple-imputed dataset. Options include
\code{MAR}, \code{J2R}, \code{CR}, and \code{delta} adjustment.
Default is MAR.}

\item{delta}{specific value used for Delta adjustment, applicable only
for method="delta".}

\item{algorithm}{either algorithm \code{tang_seq} proposed by Tang (2018) or
\code{jags} the original method inherited in JAGS (Plummer 2003).}

\item{rinv}{a small number used to adjusting Fish information matrix}

\item{scheme}{scheme of distribution used for proposing coefficients of imputation models.
scheme=1: beta ~ N( mean + inv(I)*score, inv(I));
scheme=2: beta ~ N( mean , inv(I)).}

\item{model_order}{optional. manually specify an order for imputation models.}

\item{models}{optional; named vector specifying the types of models for
(incomplete) covariates.
This arguments replaces the argument \code{meth} used in
earlier versions.
If \code{NULL} (default) models will be determined
automatically based on the class of the respective columns of
\code{data}.}

\item{ord_cov_dummy}{optional. specify whether ordinal variables should be treated as
categorical variables or continuous variables when they are
included as covariates in the sequential imputation models.
Default is \code{TRUE}, dummy variables will be created accordingly.}

\item{n.chains}{number of MCMC chains}

\item{n.adapt}{number of iterations for adaptation of the MCMC samplers
(see \code{\link[rjags]{adapt}})}

\item{n.iter}{number of iterations of the MCMC chain (after adaptation;
see \code{\link[rjags]{coda.samples}})}

\item{thin}{thinning interval (integer; see \code{\link[coda]{window.mcmc}}).
For example, \code{thin = 1} (default) will keep the MCMC samples
from all iterations; \code{thin = 5} would only keep every 5th
iteration.}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{seed}{optional; seed value (for reproducibility)}

\item{exclude_chains}{optional vector of the index numbers of chains that
should be excluded}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC
sample). Follows the same principle as the argument
\code{monitor_params} and \code{selected_parms}.}

\item{include}{logical, if TRUE, raw data will be included in imputed data sets
with imputation ID = 0.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}.}

\item{progress.bar}{character string specifying the type of
progress bar. Possible values are "text" (default), "gui",
and "none" (see \code{\link[rjags]{update}}). Note: when
sampling is performed in parallel it is not possible to
display a progress bar.}

\item{...}{additional, optional arguments
\describe{
\item{\code{trunc}}{named list specifying limits of truncation for the
distribution of the named incomplete variables (see the
vignette
\href{https://nerler.github.io/JointAI/articles/ModelSpecification.html#functions-with-restricted-support}{ModelSpecification})}
\item{\code{hyperpars}}{list of hyper-parameters, as obtained by
\code{\link[JointAI]{default_hyperpars}()}}
\item{\code{scale_vars}}{named vector of (continuous) variables that
will be centred and scaled (such that mean = 0 and sd = 1)
when they enter a linear predictor to improve
convergence of the MCMC sampling. Default is that all
numeric variables and integer variables with >20 different
values will be scaled.
If set to \code{FALSE} no scaling will be done.}
\item{\code{custom}}{named list of JAGS model chunks (character strings)
that replace the model for the given variable.}
\item{\code{append_data_list}}{list that will be appended to the list
containing the data that is passed to \strong{rjags}
(\code{data_list}). This may be necessary if additional data /
variables are needed for custom (covariate) models.}
\item{\code{progress.bar}}{character string specifying the type of
progress bar. Possible values are "text" (default), "gui",
and "none" (see \code{\link[rjags]{update}}). Note: when
sampling is performed in parallel it is not possible to
display a progress bar.}
\item{\code{quiet}}{logical; if \code{TRUE} then messages generated by
\strong{rjags} during compilation as well as the progress bar
for the adaptive phase will be suppressed,
(see \code{\link[rjags]{jags.model}})}
\item{\code{keep_scaled_mcmc}}{should the "original" MCMC sample (i.e.,
the scaled version returned by \code{coda.samples()}) be
kept? (The MCMC sample that is re-scaled to the scale of the
data is always kept.)}
\item{\code{modelname}}{character string specifying the name of the
model file (including the ending, either .R or .txt). If
unspecified a random name will be generated.}
\item{\code{modeldir}}{directory containing the model file or directory
in which the model file should be written. If unspecified a
temporary directory will be created.}
\item{\code{overwrite}}{logical; whether an existing model file with
the specified \code{<modeldir>/<modelname>} should be
overwritten. If set to \code{FALSE} and a model already
exists, that model will be used. If unspecified (\code{NULL})
and a file exists, the user is asked for input on how to
proceed.}
\item{\code{keep_model}}{logical; whether the created JAGS model file
should be saved or removed from (\code{FALSE}; default) when
the sampling has finished.}
}}
}
\value{
A list includes (1) Information from JAGS modeling and MCMC samples
and (2) A \code{data.frame} in which the original data (if
\code{include = TRUE}) and the imputed datasets are stacked onto
each other.\cr
The variable \code{Imputation_} indexes the imputation, while
\code{.rownr} links the rows to the rows of the original data.
In cross-sectional datasets the
variable \code{.id} is added as subject identifier.
}
\description{
Reference-Based Multiple Imputation for Ordinal/Binary Response
}
\examples{

\donttest{
data(schizow)

test = remiod(formula = y6 ~ tx + y0 + y1 + y3, data = schizow,
              trtvar = 'tx', algorithm = 'jags', method="MAR",
              ord_cov_dummy = FALSE, n.adapt = 10, n.chains = 1,
              n.iter = 10, thin = 2, warn = FALSE, seed = 1234)
}

}
