% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_HMM_data.R
\name{simulate_HMM_data}
\alias{simulate_HMM_data}
\title{Simulate Hidden Markov Model (HMM) Data}
\usage{
simulate_HMM_data(seed_num, p_noise, N, N_persub, parameters_setting)
}
\arguments{
\item{seed_num}{Seed for reproducibility.}

\item{p_noise}{Number of noise covariates.}

\item{N}{Number of subjects.}

\item{N_persub}{Number of time points per subject.}

\item{parameters_setting}{A list containing the parameters for the HMM.}
}
\value{
A list containing the design matrix (X_array) and response variable matrix (y_mat).
}
\description{
Generate synthetic HMM data for testing and validation purposes. This function creates a simulated dataset with specified parameters, including initial probabilities, transition probabilities, emission matrix, and noise covariates.
}
\examples{
seed_num <- 1
p_noise <- 2
N <- 100
N_persub <- 50
parameters_setting <- list(
  init_vec = c(0.5, 0.5),
  trans_mat = matrix(c(0.7, 0.3, 0.2, 0.8), nrow = 2, byrow = TRUE),
  emis_mat = matrix(c(1, 0.5, 0.5, 2), nrow = 2, byrow = TRUE)
)
simulated_data <- simulate_HMM_data(seed_num, p_noise, N, N_persub, parameters_setting)

}
