% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_basis.R
\name{smooth.construct.pi.smooth.spec}
\alias{smooth.construct.pi.smooth.spec}
\title{Parametric Interaction basis constructor}
\usage{
\method{smooth.construct}{pi.smooth.spec}(object, data, knots)
}
\arguments{
\item{object}{a smooth specification object, generated by, e.g.,
\code{s(x, y, t, bs="pi", xt=list(g=list(g1, g2, g3)))}. For
transformation functions \code{g1}, \code{g2}, and \code{g3}, see
Details below.}

\item{data}{a list containing the variables of the smooth (\code{x},
\code{y}, and \code{t} above), as well as any \code{by} variable.}

\item{knots}{a list containing any knots supplied for basis setup - in same
order and with same names as \code{data}. Can be \code{NULL}.}
}
\value{
An object of class "pi.smooth". See
   \code{\link[mgcv]{smooth.construct}} for the elements it will contain.
}
\description{
The \code{pi} basis is appropriate for smooths of multiple variables. Its
purpose is to parameterize the way in which the basis changes with one of
those variables. For example, suppose the smooth is over three variables,
\eqn{x}, \eqn{y}, and \eqn{t}, and we want to parameterize the effect of
\eqn{t}. Then the \code{pi} basis will assume \eqn{f(x,y,t) = \sum_k
g_k(t)*f_k(x,y)}, where the \eqn{g_k(t)} functions are pre-specified and the
\eqn{f_k(x,y)} functions are estimated using a bivariate basis. An example of
a parametric interaction is a linear interaction, which would take the form
\eqn{f(x,y,t) = f_1(x,y) + t*f_2(x,y)}.
}
\details{
All functions \eqn{f_k()} are defined using the same basis set.
Accordingly, they are penalized using a single block-diagonal penalty matrix
and one smoothing parameter. Future versions of this function may be able
to relax this assumption.


\code{object} should be defined (using \code{s()}) with an \code{xt}
argument. This argument is a list that could contain any of the following
elements:
\enumerate{
  \item \code{g}: the functions \eqn{g_k(t)}, specified as described below.
  \item \code{bs}: the basis code used for the functions \eqn{f_k()}; defaults
    to thin-plate regression splines, which is mgcv's default. The same
    basis will be used for all \eqn{k}.
  \item \code{idx}: an integer index indicating which variable from
    \code{object$term} is to be parameterized, i.e., the \eqn{t} variable;
    defaults to \code{length(object$term)}
  \item \code{mp}: flag to indicate whether multiple penalties should
    be estimated, one for each \eqn{f_k()}. Defaults to \code{TRUE}. If
    \code{FALSE}, the penalties for each \eqn{k} are combined into a single
    block-diagonal penalty matrix (with one smoothing parameter).
  \item \code{...}: further \code{xt} options to be passed onto the basis for
    \eqn{f_k()}.
}
\code{xt$g} can be entered in one of the following forms:
\enumerate{
  \item a list of functions of length \eqn{k}, where each function is of
  one argument (assumed to be \eqn{t})
  \item one of the following recognized character strings: \code{"linear"},
  indicating a linear interaction, i.e. \eqn{f(x,t) = f_1(x)+t*f_2(x)};
  \code{"quadratic"}, indicating a quadratic interaction, i.e.
  \eqn{f(x,t) = f_1(x)+t*f_2(x) + t^2*f_3(x)}; or
  \code{"none"}, indicating no interaction with \eqn{t}, i.e.
  \eqn{f(x,t)=f_1(x)}.
}
The only one of the above elements that is required is \code{xt}.
If default values for \code{bs}, \code{idx}, and \code{mp} are desired,
\code{xt} may also be entered as the \code{g} element itself; i.e.
\code{xt=g}, where \code{g} is either the list of functions or an acceptable
character string.

Additional arguments for the lower-dimensional basis over \code{f_k} may
be entered using the corresponding arguments of \code{s()}, e.g.
\code{k}, \code{m}, \code{sp}, etc. For example,
\code{s(x, t, bs="pi", k=15, xt=list(g="linear", bs="ps"))}
will define a linear interaction with \code{t} of a univariate p-spline
basis of dimension 15 over \code{x}.
}
\author{
Fabian Scheipl and Jonathan Gellar
}
