% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{is.nullref}
\alias{is.nullref}
\title{Is Reference Null?}
\usage{
is.nullref(x)
}
\arguments{
\item{x}{object of class \code{"ref"}}
}
\value{
\code{TRUE} if \code{x} is not a reference or points to an object that does not exist; otherwise \code{FALSE}.
}
\description{
Check whether a \code{\link{ref}} points to a \code{NULL} object or an object
that no longer exists.
}
\examples{
# Create a vectors of random numbers and a reference
x <- rnorm(10)
ref_to_x <- ref(x)

# Delete 'x' and check if NULL
is.nullref(ref_to_x) # FALSE
rm(x)
is.nullref(ref_to_x) # TRUE

}
