% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{getSym}
\alias{getSym}
\alias{setSym}
\title{Extract or Set Reference Symbol}
\usage{
getSym(x)

setSym(x, sym)
}
\arguments{
\item{x}{object of class \code{"ref"}}

\item{sym}{symbol or character naming the object to which the reference points}
}
\value{
character of length 1
}
\description{
Functions to obtain or set the object name to which a \code{\link{ref}} or \code{\link{sref}} object points.
}
\examples{
x <- 1:10
ref_to_x <- ref(x)
ref_env  <- getEnv(ref_to_x)
ref_sym  <- getSym(ref_to_x)

identical(ref_env, .GlobalEnv)
identical(ref_sym, "x")

y <- 500
ref_to_x <- setSym(ref_to_x, y)
!ref_to_x

}
