% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{splits_multi}
\alias{splits_multi}
\title{Compute Number of Administrative Units Split More than Once}
\usage{
splits_multi(plans, shp, admin)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{admin}{Unqouted name of column in \code{shp} with numeric identifiers for administrative units.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Compute Number of Administrative Units Split More than Once
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
splits_multi(plans = nh$r_2020, shp = nh, admin = county)

# Or many plans:
splits_multi(plans = nh_m[, 3:5], shp = nh, admin = county)

}
\concept{splits}
