% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_redbook.R
\name{check_redbooklist}
\alias{check_redbooklist}
\title{Check Species Names in the Red Book of Endemic Plants of Peru}
\usage{
check_redbooklist(splist, dist = 0.02)
}
\arguments{
\item{splist}{A character vector containing the species names to be checked.}

\item{dist}{Maximum allowed distance for fuzzy matching of species names.}
}
\value{
A character vector indicating if each input species name is listed as "endemic"
in the Red Book of Endemic Plants of Peru database. Returns "endemic" if the species name
is listed and "not endemic" if no matching entry is found.
}
\description{
This function checks a list of species names against the Red Book of Endemic Plants
of Peru database and provides information about whether a species was recorded as endemic,
and checks for misspelling typos (fuzzy match).
}
\details{
This function checks each species name in the provided list against the
Red Book of Endemic Plants of Peru database using fuzzy matching based on
the specified maximum distance (\code{dist}). It provides information about the
endemic status of each species and flags if the recorded name needs updating.
It also counts the number of exact and fuzzy matches found.
}
\examples{
# Example usage of the function
splist <- c("Aphelandra cuscoenses",
            "Piper stevensi",
            "Sanchezia ovata",
            "Verbesina andina",
            "Festuca dentiflora",
            "Eucrosia bicolor var. plowmanii",
            "Hydrocotyle bonplandii var. hirtipes",
            "Persea americana")

# Basic usage
check_redbooklist(splist = splist, dist = 0.2)

# Using base R with a data frame
plant_list <- data.frame(splist = splist)
plant_list$label <- check_redbooklist(plant_list$splist, dist = 0.2)
plant_list

}
\references{
\href{https://revistasinvestigacion.unmsm.edu.pe/index.php/rpb/issue/view/153}{Red Book of Endemic Plants of Peru}
\href{https://www.nature.com/articles/s41597-021-00997-6#citeas}{The World Checklist of Vascular Plants, a continuously updated resource for exploring global plant diversity.}
\href{https://tnrs.biendata.org/}{Taxonomic Name Resolution Service - TNRS}
\href{http://www.plantsoftheworldonline.org/}{Plants of the World Online - Facilitated by the Royal Botanic Gardens - Kew.}
}
