% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clean_rows.R
\name{get_failed_tests_string}
\alias{get_failed_tests_string}
\title{Get Failed Tests as a String}
\usage{
get_failed_tests_string(playback, ignore_tests = NULL,
  ignore_cols = NULL, ignore_combinations = NULL)
}
\arguments{
\item{playback}{\code{data.playback} to extract failed tests from.}

\item{ignore_tests}{\code{character} ignore test results from tests with 
these names.}

\item{ignore_cols}{\code{character} ignore test results from tests of 
columns with these names.}

\item{ignore_combinations}{\code{list} ignore test results from specific 
tests of specific columns.}
}
\value{
\code{character} with one entry for each row in new data. Each
entry concatenates information of the tests, that did NOT pass for the
corresponding row in new data.
}
\description{
Concatenates information of the tests that failed into one single
character vector.
}
\details{
Look up the descriptions and other meta data of the available 
validation tests with \code{\link{get_tests_meta_data}}.
}
\examples{
# record tape from `iris`.
tape <- record(iris)
# load data.
data(iris_newdata)
# validate new data by playing new tape on it.
playback <- play(tape, iris_newdata)

get_failed_tests_string(playback)
get_failed_tests_string(playback, ignore_tests = "outside_range")
get_failed_tests_string(playback, ignore_cols = "junk")
get_failed_tests_string(playback, ignore_combinations = list(outside_range = "Sepal.Width"))
}
