% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R, R/hydrobudget-results.R
\name{write_recharge_results}
\alias{write_recharge_results}
\alias{write_recharge_results.default}
\alias{write_recharge_results.hydrobudget}
\title{Write result as data files}
\usage{
write_recharge_results(obj, water_budget, output_dir = tempdir(), ...)

\method{write_recharge_results}{default}(obj, water_budget, output_dir = tempdir(), ...)

\method{write_recharge_results}{hydrobudget}(
  obj,
  water_budget,
  output_dir = tempdir(),
  format = "csv",
  input_rcn = NULL,
  names = list(lon = list(longname = "Longitude", unit = "deg"), lat = list(longname =
    "Lattitude", unit = "deg"), time = list(longname =
    "Month since start of the water budget", unit = "month")),
  ...
)
}
\arguments{
\item{obj}{The recharge object.}

\item{water_budget}{The computed water budget.}

\item{output_dir}{The output directory where result files will be written. Default is a temporary directory.}

\item{...}{Other arguments passed to methods}

\item{format}{The file output format. Use "nc" for NetCDF format. Default is "csv".}

\item{input_rcn}{The RCN values. Input can be a data.frame/data.table or a path to a data file.}

\item{names}{The long names and units of the NetCDF dimensions.}
}
\value{
(Invisible) the output directory.
}
\description{
Export water budget.

Supported formats are "csv" (default) or "nc" (NetCDF).
}
