% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rescale}
\alias{rescale}
\title{Scales a point cloud (3D)}
\usage{
rescale(x, y, z, scalex = 1, scaley = 1, scalez = 1)
}
\arguments{
\item{x}{vector of x axis values of scale point cloud}

\item{y}{vector of y axis values of scale point cloud}

\item{z}{vector of z axis values of scale point cloud}

\item{scalex}{scaling factor on x axis (default = 1)}

\item{scaley}{scaling factor on y axis (default = 1)}

\item{scalez}{scaling factor on z axis (default = 1)}
}
\value{
data.frame with the spatial coordinates of the resulting points
}
\description{
Scales a 3D point cloud on every axis.
}
\examples{
s <- draw_sphere(1,1,1,3)

#library(rgl)
#plot3d(s)

s2 <- rescale(s$x, s$y, s$z, scalex = 4, scalez = 5)

#library(rgl)
#plot3d(s2)

}
