% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdsubregionlist.R
\name{ebirdsubregionlist}
\alias{ebirdsubregionlist}
\title{List sub-regions within a specified region.}
\usage{
ebirdsubregionlist(
  regionType = c("country", "subnational1", "subnational2"),
  parentRegionCode,
  key = NULL,
  ...
)
}
\arguments{
\item{regionType}{The type of region to search for. Must be one of 'country',
'subnational1' or 'subnational2'.}

\item{parentRegionCode}{The region to search within. Must be a valid 
country or subnational1 code. If `regionType` is 'country' then this 
parameter is ignored (since the search will automatically be world-wide).}

\item{key}{eBird API key. You can obtain one from https://ebird.org/api/keygen.
We strongly recommend storing it in your \code{.Renviron} file as an
environment variable called \code{EBIRD_KEY}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame containing:

"code": eBird code for the subregion

"name": full name for the subregion
}
\description{
List sub-regions within a specified region.
}
\examples{
\dontrun{
ebirdsubregionlist("country")
ebirdsubregionlist("subnational1", "US")
ebirdsubregionlist("subnational2", "US-NY")
}
}
\references{
\url{http://ebird.org/}
}
\author{
David Bradnum \email{dbradnum@gmail.com}
}
