% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd2sal.R
\name{ctd2sal}
\alias{ctd2sal}
\title{Compute salinity (PSU) from conductivity, water temperature, and depth}
\usage{
ctd2sal(cond, temp, dbar)
}
\arguments{
\item{cond}{Conductance (microS/cm)}

\item{temp}{Water temperature (degrees C)}

\item{dbar}{Pressure (dBar) or water depth (m)}
}
\value{
Salinity in PSU
}
\description{
Computes salinity from conductivity, water temperature, and depth.
}
\section{Warning}{

If specific conductivity is returned from the sonde, the temperature at which specific conductivity is computed should be utilized
}

\examples{
Sonde <- realTimeloads::ExampleData$Sonde
sal <- ctd2sal(Sonde$Conductivity_uS_per_cm,Sonde$Water_Temperature_degC,Sonde$Pressure_dbar)
}
\references{
Fofonoff, N. P., & Millard Jr, R. C. (1983). Algorithms for the computation of fundamental properties of seawater.

Chen, C. T. A., & Millero, F. J. (1986). Thermodynamic properties for natural waters covering only the limnological range 1. Limnology and Oceanography, 31(3), 657-662.

Hill, K., Dauphinee, T., & Woods, D. (1986). The extension of the Practical Salinity Scale 1978 to low salinities. IEEE Journal of Oceanic Engineering, 11(1), 109-112.

Author modified Matlab code from David Schoellhamer
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
