// Code generated by the R package readsdr v0.3.0
// See more info at github https://github.com/jandraor/readsdr
functions {
  vector X_model(real time, vector y, array[] real params) {
    vector[2] dydt;
    real H_births;
    real H_deaths;
    real L_deaths;
    real L_births;
    H_births = params[1]*y[1];
    H_deaths = params[3]*y[1]*y[2];
    L_deaths = params[2]*y[2];
    L_births = params[4]*y[1]*y[2];
    dydt[1] = H_births-H_deaths;
    dydt[2] = L_births-L_deaths;
    return dydt;
  }
}
data {
  int<lower = 1> n_obs;
  array[n_obs] real y;
  array[n_obs] real z;
  real y0;
  real z0;
  array[n_obs] real ts;
  int<lower = 1> n_fcst;
}
parameters {
  real<lower = 0> par_alpha;
  real<lower = 0> par_gamma;
  real<lower = 0> par_beta;
  real<lower = 0> par_delta;
  real<lower = 0> sigma_1;
  real<lower = 0> sigma_2;
  real<lower = 0> H0;
  real<lower = 0> L0;
}
transformed parameters{
  array[n_obs] vector[2] x; // Output from the ODE solver
  array[4] real params;
  vector[2] x0; // init values
  x0[1] = H0; // Hares
  x0[2] = L0; // Lynx
  params[1] = par_alpha;
  params[2] = par_gamma;
  params[3] = par_beta;
  params[4] = par_delta;
  x = ode_rk45(X_model, x0, 0, ts, params);
}
model {
  par_alpha ~ normal(1, 0.5);
  par_gamma ~ normal(1, 0.5);
  par_beta ~ normal(0.5, 0.5);
  par_delta ~ normal(0.5, 0.5);
  sigma_1 ~ lognormal(-1, 1);
  sigma_2 ~ lognormal(-1, 1);
  H0 ~ lognormal(2.30258509299405, 1);
  L0 ~ lognormal(2.30258509299405, 1);
  y ~ lognormal(log(x[:, 1]), sigma_1);
  z ~ lognormal(log(x[:, 2]), sigma_2);
  y0 ~ lognormal(log(x0[1]), sigma_1);
  z0 ~ lognormal(log(x0[2]), sigma_1);
}
generated quantities {
  real log_lik;
  array[n_obs] real sim_y;
  array[n_obs] real sim_z;
  real sim_y0;
  real sim_z0;
  array[n_fcst] real fcst_y;
  array[n_fcst] real fcst_z;
  array[n_fcst] vector[2] x_fcst; // Forecast
  array[n_fcst] real t_fcst;
  vector[2] x_fcst0; // Forecast init values
  log_lik = lognormal_lpdf(y | log(x[:, 1]), sigma_1) +
    lognormal_lpdf(z | log(x[:, 2]), sigma_2) +
    lognormal_lpdf(y0 | log(x0[1]), sigma_1) +
    lognormal_lpdf(z0 | log(x0[2]), sigma_1);
  // Simulate forecast
  x_fcst0 = x[n_obs, :];
  t_fcst = linspaced_array(n_fcst, 1, n_fcst);
  x_fcst = ode_rk45(X_model, x_fcst0, 0, t_fcst, params);
  sim_y = lognormal_rng(log(x[:, 1]), sigma_1);
  sim_z = lognormal_rng(log(x[:, 2]), sigma_2);
  sim_y0 = lognormal_rng(log(x0[1]), sigma_1);
  sim_z0 = lognormal_rng(log(x0[2]), sigma_1);
  fcst_y = lognormal_rng(log(x_fcst[:, 1]), sigma_1);
  fcst_z = lognormal_rng(log(x_fcst[:, 2]), sigma_2);
}
