% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpreters.R
\name{sd_interpret_estimates}
\alias{sd_interpret_estimates}
\title{Interpret estimates}
\usage{
sd_interpret_estimates(estimates, par_list)
}
\arguments{
\item{estimates}{A list or data frame}

\item{par_list}{A list}
}
\value{
A data frame
}
\description{
Interpret estimates
}
\examples{
  estimates <- c(par_beta = 0,
                 par_rho  = 0.8472979,
                 I0       = 0,
                 inv_phi  = -2.302585)

  par_list <- list(list(par_name  = "par_beta",
                        par_trans = "exp"),
                   list(par_name  = "par_rho",
                        par_trans = "expit"),
                   list(par_name  = "I0",
                        par_trans = "exp"),
                   list(par_name  = "phi",
                        par_trans = c("exp", "inv")))
  sd_interpret_estimates(estimates, par_list)
}
