% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{tooltip}
\alias{tooltip}
\title{Apply a tooltip to cells.}
\usage{
tooltip(data, number_fmt = NULL)
}
\arguments{
\item{data}{Null.}

\item{number_fmt}{Optionally format numbers using formats from the scales package.
Default is NULL.}
}
\value{
a function that applies a tooltip to a reactable table.
}
\description{
Apply a tooltip to cells.
}
\examples{
\dontrun{
data <- iris[10:29, ]

## Apply a tooltip to color_scales()
reactable(data,
 columns = list(
 Petal.Length = colDef(
 cell = tooltip(),
 style = color_scales(data))
 ))
}
}
