% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{darkly}
\alias{darkly}
\title{Theme darkly}
\usage{
darkly(
  font_size = 14,
  font_color = "#ffffff",
  header_font_size = 15,
  header_font_color = "#afbdcc",
  cell_padding = 6,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 14.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #ffffff.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is #afbdcc.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Bootstrap-inspired darkly theme
}
\examples{
data <- iris[10:29, ]

## Standard darkly theme
reactable(data,
          theme = darkly())

## Additional options applied
reactable(data,
          theme = darkly(font_size = 12, font_color = "grey", cell_padding = 3))

}
