% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{cell_style}
\alias{cell_style}
\title{Add custom styles to cells}
\usage{
cell_style(
  data,
  rows = NULL,
  values = NULL,
  font_color = NULL,
  font_size = NULL,
  font_style = "normal",
  font_weight = "normal",
  horizontal_align = "right",
  vertical_align = "top",
  text_decoration = NULL,
  border_width = NULL,
  border_style = NULL,
  border_color = NULL,
  background_color = NULL,
  animation = "1s ease"
)
}
\arguments{
\item{data}{A dataset to be displayed within a {reactable} table.}

\item{rows}{Numeric value representing the row number to apply the custom style.
Can provide a vector of rows if applying to more than one row.
If no rows are provided, styles are applied to all rows/values.}

\item{values}{A value, either numeric or character, that is present within a column.
Can provide a vector of values if applying to more than one value.
If no values are provided, styles are applied to all rows/values.}

\item{font_color}{Color of the text.}

\item{font_size}{Numeric value representing the size of the font of the text (in px).
Default is 16.}

\item{font_style}{Style of the text font.
Options are "normal" or "italic".
Default is "normal".}

\item{font_weight}{The font weight of the text
Options are "normal", "bold", "bolder", "lighter" or a value between 100 and 900.
Default is "normal".}

\item{horizontal_align}{The horizontal alignment of the text within a cell.
Options are "left", "right", or "center".
Default is "right".}

\item{vertical_align}{The vertical alignment of the text within a cell.
Options are "top", "bottom", or "center".
Default is "top".}

\item{text_decoration}{Optionally add an underline, overline, or line-through to the text
Options are "underline", "overline", "underline overline", or "line-through".
Default is NULL.}

\item{border_width}{The width of the border around the cell.
Options are "thin", "medium", "thick", or a numeric value such as "2px".
May be specified using one, two, three, or four values.
See [CSS border-width](https://developer.mozilla.org/en-US/docs/Web/CSS/border-width) for more options.}

\item{border_style}{The style of the border around the cell.
Options are "solid", "dashed", "dotted", "double", "groove", "ridge", "inset", "outset", "none", or "hidden".
May be specified using one, two, three, or four values.
See [CSS border-style](https://developer.mozilla.org/en-US/docs/Web/CSS/border-style) for more options.}

\item{border_color}{The color of the border around the cell.
May be specified using one, two, three, or four values.
See [CSS border-color](https://developer.mozilla.org/en-US/docs/Web/CSS/border-color) for more options.}

\item{background_color}{Color of the background of the cell.}

\item{animation}{Control the duration and timing function of the animation
when sorting/updating values shown on a page.
See [CSS transitions](https://developer.mozilla.org/en-US/docs/Web/CSS/transition)
for available timing functions and examples.
Animation can be turned off by setting to "none".
Default is "1s ease".}
}
\value{
a function that adds a custom style to a row or rows in a reactable table.
}
\description{
Use `cell_style()` to customize the appearance of certain cells in a {reactable} or {reactablefmtr} table.
     Assign custom styles by either row number(s) or by values within a particular column.
     The font color, font size, font style, and font weight can all be modified.
     Borders can also be placed around cells and customized by style, width, and color.
     By default, animation is applied to the cells that are styled, but can be turned off by setting to 'none'.
     Some options within `cell_style()` will work with other {reactablefmtr} formatters (such as data_bars() and color_tiles()),
     but it is not fully supported and should be used separately, not together.
     `cell_style()` needs to be placed within the style argument of reactable::colDef.
}
\examples{
\dontrun{
## Add a dotted blue border around the third row in Sepal.Length
data <- iris[10:29, ]
reactable(data,
         columns = list(
           Sepal.Length = colDef(
             style = cell_style(data,
                                rows = 3,
                                border_width = "thick",
                                border_color = "blue",
                                border_style = "dotted"))))

## For all setosa species, highlight cell yellow and assign red font color
data <- iris[10:100, ]
reactable(data,
         columns = list(
         Species = colDef(
             style = cell_style(data,
                                values = "setosa",
                                font_color = "red",
                                background_color = "yellow"))))
}
}
