% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_raster.R
\name{retrieve_raster}
\alias{retrieve_raster}
\title{Write a raster layer from the current GRASS mapset to file}
\usage{
retrieve_raster(layer, out_layer, overwrite = FALSE, ...)
}
\arguments{
\item{layer}{The name of the raster in the GRASS mapset that is to be written out.}

\item{out_layer}{The name of the file to be created, with the relevant file extension.}

\item{overwrite}{A logical indicating whether the output from this function should be allowed to overwrite any existing files. Defaults to \code{FALSE}.}

\item{...}{Additional arguments to \code{r.out.gdal}.}
}
\value{
Nothing.
}
\description{
This function writes a GRASS mapset raster to file.
}
\examples{
# Will only run if GRASS is running
if(check_running()){

# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")

# Set environment parameters and import data to GRASS
set_envir(dem)
raster_to_mapset(rasters = dem, as_integer = FALSE)

# Retrieve raster 
out_name <- paste0(tempdir(), "/retrieved_dem.tif")
retrieve_raster("dem.tif", out_layer = out_name, overwrite = TRUE)

}
}
