% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/othrStdyMat.R
\name{ddi_othrStdyMat}
\alias{ddi_othrStdyMat}
\alias{ddi_othRefs}
\alias{ddi_relMat}
\alias{ddi_relPubl}
\alias{ddi_relStdy}
\title{othrStdyMat and its child nodes}
\usage{
ddi_othrStdyMat(...)

ddi_othRefs(...)

ddi_relMat(...)

ddi_relPubl(...)

ddi_relStdy(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Other study description materials relating to the study description. This
section describes other materials that are related to the study description
that are primarily descriptions of the content and use of the study, such as
appendices, sampling information, weighting details, methodological and
technical details, publications based upon the study content, related
studies or collections of studies, etc. This section may point to other
materials related to the description of the study through use of the generic
citation element, which is available for each element in this section. This
maps to Dublin Core Relation element.More information on these elements,
especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{othrStdyMat} is contained in \code{stdyDscr}.

\emph{othrStdyMat specific child nodes}
\itemize{
\item \code{ddi_othRefs()} indicates other pertinent references. can take the form of
natural language text and/or bibliographic citations using ddi_citation().
\item \code{ddi_relMat()} describes materials related to the study description, such
as appendices, additional information on sampling found in other documents,
etc. Can take the form of natural language text and/or bibliographic citations
using ddi_citation(). This element can contain either PCDATA or a citation or
both, and there can be multiple occurrences of both the citation and PCDATA
within a single element. May consist of a single URI or a series of URIs
comprising a series of citations/references to external materials which can
be objects as a whole (journal articles) or parts of objects (chapters or
appendices in articles or documents).
\item \code{ddi_relPubl()} are bibliographic and access information about articles
and reports based on the data in this collection. Can take the form of
natural language text and/or bibliographic citations using ddi_citation().
\item \code{ddi_relStdy()} is information on the relationship of the current data
collection to others (e.g., predecessors, successors, other waves or rounds)
or to other editions of the same file. This would include the names of
additional data collections generated from the same data collection vehicle
plus other collections directed at the same general topic. Can take the form
of natural language text and/or bibliographic citations using ddi_citation().
}
}
\examples{
ddi_othrStdyMat()

# Functions that need to be wrapped in ddi_othrStdyMat()

ddi_othRefs("Part II of the documentation, the Field Representative's Manual, 
            is provided in hardcopy form only.")

ddi_relMat("Full details on the research design and procedures, sampling 
           methodology, content areas, and questionnaire design, as well as 
           percentage distributions by respondent's sex, race, region, college 
           plans, and drug use, appear in the annual ISR volumes MONITORING 
           THE FUTURE: QUESTIONNAIRE RESPONSES FROM THE NATION'S HIGH SCHOOL 
           SENIORS.")
           
ddi_relPubl("Economic Behavior Program Staff. SURVEYS OF CONSUMER FINANCES. 
            Annual volumes 1960 through 1970. Ann Arbor, MI: Institute for 
            Social Research.")
            
ddi_relStdy("ICPSR distributes a companion study to this collection titled 
             FEMALE LABOR FORCE PARTICIPATION AND MARITAL INSTABILITY, 1980: 
             [UNITED STATES] (ICPSR 9199).")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/othrStdyMat.html}{othrStdyMat documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/othRefs.html}{othRefs documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/relMat.html}{relMat documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/relPubl.html}{relPubl documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/relStdy.html}{relStdy documentation}
}
