% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_catgry}
\alias{ddi_catgry}
\alias{ddi_catgryGrp}
\alias{ddi_catStat}
\alias{ddi_catValu}
\title{catgry, catgryGrp and their child nodes}
\usage{
ddi_catgry(...)

ddi_catgryGrp(...)

ddi_catStat(...)

ddi_catValu(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
\code{catgry} is a description of a particular categorical response.
\code{ddi_catgryGrp()} groups the responses together. More information on these
elements, especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{catgry} and \code{catgryGrp} is contained in \code{var}.

\emph{catgry and catgryGrp specific child nodes}
\itemize{
\item \code{ddi_catStat()} is a category level statistic. May include frequencies,
percentages, or crosstabulation results. The attribute "type" indicates the
type of statistics presented - frequency, percent, or crosstabulation. If a
value of "other" is used for this attribute, the "otherType" attribute should
take a value from a controlled vocabulary. This option should only be used
when applying a controlled vocabulary to this attribute. Use the complex
element controlledVocabUsed to identify the controlled vocabulary to which
the selected term belongs.
}

\emph{catgry specific child nodes}
\itemize{
\item \code{ddi_catValu()} is the category value.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_labl]{ddi_labl()}}
\item \code{\link[=ddi_mrow]{ddi_mrow()}}
\item \code{\link[=ddi_txt]{ddi_txt()}}
}
}

\examples{
ddi_catgry(missing = "Y", missType = "inap")
ddi_catgryGrp(missing = "N")

# Functions that need to be wrapped in ddi_catgry() or ddi_catgryGrp()

ddi_catStat(type = "freq", "256")

# Functions that need to be wrapped in ddi_catgry()

ddi_catValu("9")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/catgry.html}{catgry documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/catgryGrp.html}{catgryGrp documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/catStat.html}{catStat documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/catValu.html}{catValu documentation}
}
