% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rct3.R
\name{rct3}
\alias{rct3}
\title{Run a calibrated regression to predict recruitment}
\usage{
rct3(
  formula,
  data,
  predictions = NULL,
  shrink = FALSE,
  power = 3,
  range = 20,
  min.se = 0.2,
  old = TRUE
)
}
\arguments{
\item{formula}{a formula to define which surveys to use in the recruitment
estimation.}

\item{data}{a dataframe with one column named 'yearclass' and other columns
with the recruitment and the survey index relavent for that recruitment
value}

\item{predictions}{which yearclasses to make recruitment predictions for}

\item{shrink}{shrink predictions to the VPA mean?}

\item{power}{the power to use 0 - no weighting, 2 - bisquare, 3 - tricubic}

\item{range}{the year range to use in the time tapered weighting}

\item{min.se}{the minimum standard error used in the weighting of predictions}

\item{old}{default TRUE, defines how to treat zero values.  In the origional
implmentation al values were transformed using log(x + 1), old=TRUE
maintains this.}
}
\value{
Object of class \verb{rct3}.
}
\description{
Function to run a calibrated regression to predict recruitment using the
method decribed by Shepherd (1997)
}
\note{
This function was written based on the publication by Shepherd (1997)
 with additional reverse engeneering by comparing results to
previous examples run using the RCT3 ver3.1 dos program
}
\examples{
# load recruitment data
data(recdata)

formula <- recruitment ~ NT1 + NT2 + NT3 +
                         NAK1 + NAK2 + NAK3 +
                         RT1 + RT2 + RT3 +
                         EC01 + ECO2 + ECO3

my_rct3 <- rct3(formula, recdata, predictions = 2012:2017, shrink = TRUE)

# see a short summary
my_rct3

# for a full summary do:
summary(my_rct3)

# the components are here:
my_rct3$rct3
my_rct3$rct3.summary

# predicted recruitment
t(my_rct3$rct3.summary["WAP"])

}
\references{
J. G. Shepherd, Prediction of year-class strength by calibration
regression analysis of multiple recruit index series, ICES
Journal of Marine Science, Volume 54, Issue 5, October 1997,
Pages 741–752, \url{https://doi.org/10.1006/jmsc.1997.0222}
}
\seealso{
\code{\link{rct3-package}} gives an overview of the package.
}
