% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_osm_river_surface}
\alias{get_osm_river_surface}
\title{Get the river surface from OpenStreetMap}
\usage{
get_osm_river_surface(bb, river_centerline, crs = NULL, force_download = FALSE)
}
\arguments{
\item{bb}{Bounding box of class \code{bbox}}

\item{river_centerline}{The river centerline as an object of class
\code{\link[sf:sfc]{sf::sfc_LINESTRING}} or \code{\link[sf:sfc]{sf::sfc_MULTILINESTRING}}}

\item{crs}{Coordinate reference system as EPSG code}

\item{force_download}{Download data even if cached data is available}
}
\value{
The river surface as object of class \code{\link[sf:sfc]{sf::sfc_POLYGON}} or
\code{\link[sf:sfc]{sf::sfc_MULTIPOLYGON}}.
}
\description{
Get the river surface from OpenStreetMap
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
crs <- get_utm_zone(bb)
river <- get_osm_river_centerline(bb, "Dâmbovița")
get_osm_river_surface(bb = bb, river_centerline = river, crs = crs,
              force_download = FALSE)
\dontshow{\}) # examplesIf}
}
