% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_month_decomp.R
\name{ts_month_decomp}
\alias{ts_month_decomp}
\title{Time Series Decomposition for Monthly Crime Data}
\usage{
ts_month_decomp(data, start)
}
\arguments{
\item{data}{Data frame of crime or RMS data. See provided Chicago Data Portal
example for reference}

\item{start}{The year in which the time series data starts. The time series
is assumed to be composed of solely monthly count data}
}
\value{
Returns an object of class "stl" with the following components:

time.series: a multiple time series with columns seasonal, trend and remainder.

weights: the final robust weights (all one if fitting is not done robustly).

call: the matched call.

win: integer (length 3 vector) with the spans used for the "s", "t", and "l" smoothers.

deg: integer (length 3) vector with the polynomial degrees for these smoothers.

jump: integer (length 3) vector with the 'jumps' (skips) used for these smoothers.

inner: number of inner iterations
}
\description{
This function transforms traditional crime data and plots the
    resultant components of a time series which has been decomposed into
    seasonal, trend and irregular components using Loess smoothing.
}
\examples{
#Using provided dataset from Chicago Data Portal:
data(crimes)
test <- ts_month_decomp(crimes, 2017)
plot(test)
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{ts}
