library(testthat)
library(rconf)

context("Minimal YAML Parser Tests")

test_that("Basic key-value pairs are parsed", {
  yaml_text <- "a: 1\nb: hello"
  cfg <- parse_config(yaml_text)
  expect_equal(cfg$a, 1)
  expect_equal(cfg$b, "hello")
})

test_that("Inline arrays are parsed and flattened", {
  yaml_text <- "nums: [1, 2, 3]\nletters: [a, b, c]"
  cfg <- parse_config(yaml_text)
  expect_equal(cfg$nums, c(1, 2, 3))
  expect_equal(cfg$letters, c("a", "b", "c"))
})

test_that("Nested keys are parsed", {
  yaml_text <- "default:\n  a: 1\n  b: 2"
  cfg <- parse_config(yaml_text)
  expect_equal(cfg$default$a, 1)
  expect_equal(cfg$default$b, 2)
})

test_that("Inline comments are removed", {
  yaml_text <- "file_type: bam       # options: bam or bed"
  cfg <- parse_config(yaml_text)
  expect_equal(cfg$file_type, "bam")
})
