% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize-folder.R
\name{optimize_folder}
\alias{optimize_folder}
\title{Optimize a folder with `.R` files.}
\usage{
optimize_folder(
  folder,
  optimizers = all_optimizers,
  overwrite = FALSE,
  iterations = Inf,
  pattern = "\\\\.R$",
  recursive = TRUE
)
}
\arguments{
\item{folder}{Path to a directory with files to optimize.}

\item{optimizers}{A named list of optimizer functions.}

\item{overwrite}{A logical indicating if files should be overwritten, or
saved into new files with "optimized_" prefix.}

\item{iterations}{Numeric indicating the number of times optimizers should
pass. If there was no change after current pass, it will stop.}

\item{pattern}{An optional regular expression. Only file names which match
the regular expression will be optimized.}

\item{recursive}{A logical value indicating whether or not files
in subdirectories of `folder` should be optimized as well.}
}
\description{
Performs the desired optimization strategies in all the `.R` in a directory.
Carefully examine the results after running this function!
If several files interact between them (functions from one file use
functions from the other), then optimizing all of them together gives more
information to rco.
}
