% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcheology.R
\name{fun_changed}
\alias{fun_changed}
\title{Check if a core R function changed between R versions}
\usage{
fun_changed(fn, from = NULL, to = NULL, package = NULL)
}
\arguments{
\item{fn}{Character name of a function in a core R package.}

\item{from}{Minimum R version (optional).}

\item{to}{Maximum R version (optional).}

\item{package}{Name of the package (optional).}
}
\value{
0 if there was no change. 1 if the function's arguments changed.
2 if the function was not present in all versions. If the function can't
be found or exists in multiple packages, throws an error.
}
\description{
Check if a core R function changed between R versions
}
\examples{
fun_changed("debugonce")
\donttest{
fun_changed("debugonce", "3.4.0", "3.4.3")
fun_changed("debugonce", "3.3.0", "3.4.3")
}
}
