% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-diff.R, R/op-cdo-diff.R,
%   R/op-cdo-diffn.R
\name{diff}
\alias{diff}
\alias{cdo_diff}
\alias{cdo_diffn}
\title{Compare two datasets field by field}
\usage{
cdo_diff(
  ifile1,
  ifile2,
  maxcount = NULL,
  abslim = NULL,
  rellim = NULL,
  names = NULL
)

cdo_diffn(
  ifile1,
  ifile2,
  maxcount = NULL,
  abslim = NULL,
  rellim = NULL,
  names = NULL
)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{maxcount}{INTEGER - Stop after maxcount different fields}

\item{abslim}{FLOAT - Limit of the maximum absolute difference (default: 0)}

\item{rellim}{FLOAT - Limit of the maximum relative difference (default: 1)}

\item{names}{STRING - Consideration of the variable names of only one input file (left/right) or the intersection of both (intersect).}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
Compares the contents of two datasets field by field. The input datasets need to have the same structure and its fields need to have the dimensions. Try the option names if the number of variables differ. Exit status is 0 if inputs are the same and 1 if they differ.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{diff   Compare two datasets listed by parameter id
       Provides statistics on differences between two datasets.
       For each pair of fields the operator prints one line with the following information:
       - Date and Time
       - Level, Gridsize and number of Missing values
       - Number of different values
       - Occurrence of coefficient pairs with different signs (S)
       - Occurrence of zero values (Z)
       - Maxima of absolute difference of coefficient pairs
       - Maxima of relative difference of non-zero coefficient pairs with equal signs
       - Parameter identifier
diffn  Compare two datasets listed by parameter name
       The same as operator diff. Using the name instead of the
       identifier to label the parameter.
}\if{html}{\out{</div>}}
}
