% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-function.R
\name{define}
\alias{define}
\title{Define a function in the list of functions}
\usage{
define(func, which, what)
}
\arguments{
\item{func}{Functions, an object class generated by
\code{\link{function_from_edge}} or \code{\link{function_from_user}}
functions.}

\item{which}{Which, a character of length 1 indicating a vertex name for
which function is defined. The vertex name must be defined in 'Functions'.}

\item{what}{What, a function to be defined. It must use all and only
the specified arguments for the vertex in 'Functions', if not previously
defined.}
}
\value{
A list of either functions or character vectors of arguments for
function. It can be continuously defined or redefined by a user using
\code{define} function. If all elements of the list are functions, then it
can be an input for generating the simulated data.
}
\description{
Define a function in the list of functions
}
\examples{

data(edges)
functions <- function_from_edge(edges)
function_B <- function(n){ rnorm(n, 90, 5) }
functions <- define(functions, 'B', function_B)
}
\keyword{edge-specified-function-definition}
