% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chessboard.R
\name{chessboard}
\alias{chessboard}
\title{Perform chessboard segmentation}
\usage{
chessboard(r, size)
}
\arguments{
\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster}. One or more layers used to drive
heterogeneity.}

\item{size}{Numeric vector of length one. Size (in pixels) of each square
segment. Must be a positive integer.}
}
\value{
\link[terra:SpatRaster-class]{terra::SpatRaster} with one layer and integer values, where
each unique value corresponds to a square-segment ID.
}
\description{
Segment a raster into square regions of equal size arranged in a
chessboard-like pattern.
}
\details{
This function divides the extent of a \link[terra:SpatRaster-class]{terra::SpatRaster} into
non-overlapping square segments of the given size, producing a segmentation
map where each segment has a unique integer label. It can be an alternative
to \code{\link[=sky_grid_segmentation]{sky_grid_segmentation()}} in special cases.
}
\examples{
caim <- read_caim()
seg <- chessboard(caim, 20)
plot(caim$Blue)
plot(extract_feature(caim$Blue, seg))
}
