% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-cotahist.R
\name{cotahist-extracts}
\alias{cotahist-extracts}
\alias{cotahist_filter_equity}
\alias{cotahist_filter_etf}
\alias{cotahist_filter_bdr}
\alias{cotahist_filter_unit}
\alias{cotahist_filter_fii}
\alias{cotahist_filter_fidc}
\alias{cotahist_filter_fiagro}
\alias{cotahist_filter_index}
\alias{cotahist_filter_equity_options}
\alias{cotahist_filter_index_options}
\alias{cotahist_filter_fund_options}
\title{Filtering data from COTAHIST datasets}
\usage{
cotahist_filter_equity(x)

cotahist_filter_etf(x)

cotahist_filter_bdr(x)

cotahist_filter_unit(x)

cotahist_filter_fii(x)

cotahist_filter_fidc(x)

cotahist_filter_fiagro(x)

cotahist_filter_index(x)

cotahist_filter_equity_options(x)

cotahist_filter_index_options(x)

cotahist_filter_fund_options(x)
}
\arguments{
\item{x}{A cotahist dataset}
}
\value{
A dataframe containing the requested market data.
}
\description{
A set of functions that implement filters to obtain organized and useful
data from the COTAHIST datasets.
}
\details{
The functions bellow return data from plain instruments, stocks, funds and indexes.
\itemize{
\item \code{cotahist_filter_equity()} returns data for stocks and UNITs.
\item \code{cotahist_filter_etf()} returns data for ETFs.
\item \code{cotahist_filter_bdr()} returns data for BDRs.
\item \code{cotahist_filter_unit()} returns data exclusively for UNITs.
\item \code{cotahist_filter_index()} returns data for indices. The index data returned by \code{cotahist_filter_index()}
corresponds to option expiration days, meaning there is only one index quote per month.
\item \code{cotahist_filter_fii()}, \code{cotahist_filter_fidc()}, and \code{cotahist_filter_fiagro()} return data for funds.
}

The functions bellow return data related to options, from equities, indexes and funds (ETFs).
\itemize{
\item \code{cotahist_filter_equity_options()} returns data for stock options.
\item \code{cotahist_filter_index_options()} returns data for index options, currently only for IBOVESPA.
\item \code{cotahist_filter_funds_options()} returns data for fund options, currently only for ETFs.
}

The dataset provided must have at least the columns \code{isin}, \code{instrument_market}, \code{bdi_code} and \code{specification_code}.
A combination of these columns is used to filter the desired data.
}
\examples{
\dontrun{
df <- cotahist_get() |> cotahist_filter_equity()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_etf()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_bdr()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_unit()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_fii()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_fidc()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_fiagro()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_index()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_equity_options()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_index_options()
}
\dontrun{
df <- cotahist_get() |> cotahist_filter_fund_options()
}
}
