% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ks.R
\name{Ks}
\alias{Ks}
\title{Calculates Total Wavenumber for Stationary Rossby Waves (Ks)}
\usage{
Ks(
  u,
  lat = "lat",
  lon = "lon",
  uname = "uwnd",
  ofile,
  a = 6371000,
  plots = FALSE,
  show.warnings = FALSE
)
}
\arguments{
\item{u}{String indicating the input data filename. The file to be
passed consists in a netCDF file with only time-mean zonal wind at one
pressure level, latitude in ascending order (not a requisite), and longitude
from 0 to 360. It is required that the read dimensions express
longitude (in rows) x latitude (in columns).
\strong{u} also can be a numerical matrix with time-mean zonal wind at one
pressure level, latitude in ascending order (not a requisite), and longitude
from 0 to 360. It is required that the read dimensions express longitude
(in rows) x latitude (in columns).}

\item{lat}{String indicating the name of the latitude field. If
\strong{u} is a matrix, \strong{lat} must be numeric.}

\item{lon}{String indicating the name of the longitude field.If
\strong{u} is a matrix, \strong{lon} must be numeric from 0 to 360.}

\item{uname}{String indicating the variable name field}

\item{ofile}{String indicating the file name for store output data.
If missing, will not return a netCDF file}

\item{a}{Numeric indicating the Earth's radio (m)}

\item{plots}{Logical, if TRUE will produce filled.countour plots}

\item{show.warnings}{Logical, if TRUE will warns about NaNs in sqrt(<0)}
}
\value{
list with one vector (lat) and 1 matrix (Ksm)
}
\description{
\code{Ks} ingests the time-mean zonal wind (u) and calculates the Total
Wavenumber for Stationary Rossby waves (Ks) in mercator coordinates
(see: Hoskins and Ambrizzi, 1993). Stationary Rossby waves are found when
zonal wave number (k) is constant along the trajectory, which leads to wave
frequency (omega) zero.
In this code Ks is used to distinguish the total wavenumber for Stationary
Rossby Waves (Ks) from the total wavenumber for Rossby waves (K), and
zonal wave number (k).
\code{Ks} returns a list with Ks in mercator coordinates (ksm).
}
\examples{
{
# u is NetCDF and lat and lon characters
input <- system.file("extdata",
                     "uwnd.mon.mean_200hPa_2014JFM.nc",
                      package = "raytracing")
Ks <- Ks(u = input, plots = TRUE)
Ks$ksm[] <- ifelse(Ks$ksm[] >= 16 |
                   Ks$ksm[] <= 0, NA, Ks$ksm[])
cores <- c("#ff0000","#ff5a00","#ff9a00","#ffce00","#f0ff00")
graphics::filled.contour(Ks$ksm[, -c(1:5, 69:73)] ,
                         col = rev(colorRampPalette(cores, bias = 0.5)(20)),
                         main = "Ks")
}
}
