% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class011-YAEL_process.R
\name{YAELProcess}
\alias{YAELProcess}
\title{Class definition of 'YAEL' image pipeline}
\value{
whether the image has been set (or replaced)

Absolute path if the image

'RAVE' subject instance

Nothing

A list of moving and fixing images, with rigid transformations
from different formats.

See method \code{get_template_mapping}

A list of input, output images, with forward and inverse
transform files (usually two \code{'Affine'} with one displacement field)

transformed image in \code{'ANTs'} format

transformed image in \code{'ANTs'} format

Nothing

A matrix of 3 columns, each row is a transformed points (
invalid rows will be filled with \code{NA})

A matrix of 3 columns, each row is a transformed points (
invalid rows will be filled with \code{NA})
}
\description{
Rigid-registration across multiple types of images, non-linear normalization
from native brain to common templates, and map template atlas or
regions of interest back to native brain. See examples at
\code{\link{as_yael_process}}
}
\section{Super class}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{YAELProcess}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{subject_code}}{'RAVE' subject code}

\item{\code{image_types}}{allowed image types}

\item{\code{work_path}}{Working directory ('RAVE' imaging path)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-YAELProcess-@marshal}{\code{YAELProcess$@marshal()}}
\item \href{#method-YAELProcess-@unmarshal}{\code{YAELProcess$@unmarshal()}}
\item \href{#method-YAELProcess-new}{\code{YAELProcess$new()}}
\item \href{#method-YAELProcess-set_input_image}{\code{YAELProcess$set_input_image()}}
\item \href{#method-YAELProcess-get_input_image}{\code{YAELProcess$get_input_image()}}
\item \href{#method-YAELProcess-get_subject}{\code{YAELProcess$get_subject()}}
\item \href{#method-YAELProcess-register_to_T1w}{\code{YAELProcess$register_to_T1w()}}
\item \href{#method-YAELProcess-get_native_mapping}{\code{YAELProcess$get_native_mapping()}}
\item \href{#method-YAELProcess-map_to_template}{\code{YAELProcess$map_to_template()}}
\item \href{#method-YAELProcess-get_template_mapping}{\code{YAELProcess$get_template_mapping()}}
\item \href{#method-YAELProcess-transform_image_from_template}{\code{YAELProcess$transform_image_from_template()}}
\item \href{#method-YAELProcess-transform_image_to_template}{\code{YAELProcess$transform_image_to_template()}}
\item \href{#method-YAELProcess-generate_atlas_from_template}{\code{YAELProcess$generate_atlas_from_template()}}
\item \href{#method-YAELProcess-transform_points_to_template}{\code{YAELProcess$transform_points_to_template()}}
\item \href{#method-YAELProcess-transform_points_from_template}{\code{YAELProcess$transform_points_from_template()}}
\item \href{#method-YAELProcess-construct_ants_folder_from_template}{\code{YAELProcess$construct_ants_folder_from_template()}}
\item \href{#method-YAELProcess-get_brain}{\code{YAELProcess$get_brain()}}
\item \href{#method-YAELProcess-clone}{\code{YAELProcess$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-@marshal"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-@marshal}{}}}
\subsection{Method \code{@marshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$@marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-@unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-@unmarshal}{}}}
\subsection{Method \code{@unmarshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$@unmarshal(object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object, ...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-new"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-new}{}}}
\subsection{Method \code{new()}}{
Constructor to instantiate the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$new(subject, image_types, imaging_path = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{'RAVE' subject or subject ID; for native standard,
this can be character code without project names, but for 'BIDS'
subjects, this must be a full subject ID with project information}

\item{\code{image_types}}{vector of image types, such as \code{'T1w'},
\code{'CT'}, \code{'fGATIR'}. All images except \code{'CT'} will be
considered \code{'preop'} (before electrode implantation). Please
use \code{'postop'} to indicate if an image is taken after the
implantation (for example, \code{'postopT1w'})}

\item{\code{imaging_path}}{imaging path (path to \code{'rave-imaging'}
if not default); internally used to set the work path during
serialization. Please do not set it manually unless you know what you
are doing}

\item{\code{...}}{reserved for legacy code}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-set_input_image"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-set_input_image}{}}}
\subsection{Method \code{set_input_image()}}{
Set the raw input for different image types
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$set_input_image(
  path,
  type = YAEL_IMAGE_TYPES,
  overwrite = FALSE,
  on_error = c("warning", "error", "ignore")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path to the image files in \code{'NIfTI'} format}

\item{\code{type}}{type of the image}

\item{\code{overwrite}}{whether to overwrite existing images if the same type
has been imported before; default is false}

\item{\code{on_error}}{when the file exists and \code{overwrite} is false,
how should this error be reported; choices are \code{'warning'} (default),
\code{'error'} (throw error and abort), or \code{'ignore'}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-get_input_image"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-get_input_image}{}}}
\subsection{Method \code{get_input_image()}}{
Get image path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$get_input_image(type = YAEL_IMAGE_TYPES)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{type of the image}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-get_subject"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-get_subject}{}}}
\subsection{Method \code{get_subject()}}{
Get 'RAVE' subject instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$get_subject(..., strict = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}

\item{\code{strict}}{passed to \code{\link{as_rave_subject}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-register_to_T1w"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-register_to_T1w}{}}}
\subsection{Method \code{register_to_T1w()}}{
Register other images to \code{'T1'} weighted \code{'MRI'}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$register_to_T1w(image_type = "CT", reverse = FALSE, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image_type}}{type of the image to register, must be set via
\code{process$set_input_image} first.}

\item{\code{reverse}}{whether to reverse the registration; default is false,
meaning the fixed (reference) image is the \code{'T1'}. When setting to
true, then the \code{'T1'} 'MRI' will become the moving image}

\item{\code{verbose}}{whether to print out the process; default is true}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-get_native_mapping"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-get_native_mapping}{}}}
\subsection{Method \code{get_native_mapping()}}{
Get the mapping configurations used by \code{register_to_T1w}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$get_native_mapping(image_type = YAEL_IMAGE_TYPES, relative = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image_type}}{type of the image registered to 'T1' weighted 'MRI'}

\item{\code{relative}}{whether to use relative path (to the \code{work_path} field)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-map_to_template"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-map_to_template}{}}}
\subsection{Method \code{map_to_template()}}{
Normalize native brain to \code{'MNI152'} template
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$map_to_template(
  template_name = rpyants_builtin_templates(),
  use_images = c("T1w", "T2w", "T1wContrast", "fGATIR", "preopCT"),
  native_type = "T1w",
  verbose = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{template_name}}{which template to use, choices are
\code{'mni_icbm152_nlin_asym_09a'}, \code{'mni_icbm152_nlin_asym_09b'},
\code{'mni_icbm152_nlin_asym_09c'}, and \code{'fsaverage'}.}

\item{\code{use_images}}{a vector of image types to use for normalization;
default types are \code{'T1w'}, \code{'T2w'}, \code{'T1wContrast'},
\code{'fGATIR'}, and \code{'preopCT'}. To use all available images
for normalization, use wildcard \code{"all"}}

\item{\code{native_type}}{which type of image should be used to map to template;
default is \code{'T1w'}}

\item{\code{verbose}}{whether to print out the process; default is true}

\item{\code{...}}{additional tuning parameters passed to internal 'Python'
code.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-get_template_mapping"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-get_template_mapping}{}}}
\subsection{Method \code{get_template_mapping()}}{
Get configurations used for normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$get_template_mapping(
  template_name = rpyants_builtin_templates(),
  native_type = "T1w",
  relative = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{template_name}}{which template is used}

\item{\code{native_type}}{which native image is mapped to template}

\item{\code{relative}}{whether the paths should be relative or absolute; default
is false (absolute paths)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-transform_image_from_template"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-transform_image_from_template}{}}}
\subsection{Method \code{transform_image_from_template()}}{
Apply transform from images (usually an atlas or 'ROI')
on template to native space
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$transform_image_from_template(
  template_roi_path,
  template_name = rpyants_builtin_templates(),
  native_type = "T1w",
  interpolator = c("auto", "nearestNeighbor", "linear", "gaussian", "bSpline",
    "cosineWindowedSinc", "welchWindowedSinc", "hammingWindowedSinc",
    "lanczosWindowedSinc", "genericLabel"),
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{template_roi_path}}{path to the template image file which will be
transformed into individuals' image}

\item{\code{template_name}}{templates to use}

\item{\code{native_type}}{which type of native image to use for calculating
the coordinates (default \code{'T1w'})}

\item{\code{interpolator}}{how to interpolate the \code{'voxels'}; default is
\code{"auto"}: \code{'linear'} for probabilistic map and \code{'nearestNeighbor'}
otherwise.}

\item{\code{verbose}}{whether the print out the progress}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-transform_image_to_template"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-transform_image_to_template}{}}}
\subsection{Method \code{transform_image_to_template()}}{
Apply transform to images (usually an atlas or 'ROI')
from native space to template
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$transform_image_to_template(
  native_roi_path,
  template_name = rpyants_builtin_templates(),
  native_type = "T1w",
  interpolator = c("auto", "nearestNeighbor", "linear", "gaussian", "bSpline",
    "cosineWindowedSinc", "welchWindowedSinc", "hammingWindowedSinc",
    "lanczosWindowedSinc", "genericLabel"),
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{native_roi_path}}{path to the native image file that will be
transformed into template}

\item{\code{template_name}}{templates to use}

\item{\code{native_type}}{which type of native image to use for calculating
the coordinates (default \code{'T1w'})}

\item{\code{interpolator}}{how to interpolate the \code{'voxels'}; default is
\code{"auto"}: \code{'linear'} for probabilistic map and \code{'nearestNeighbor'}
otherwise.}

\item{\code{verbose}}{whether the print out the progress}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-generate_atlas_from_template"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-generate_atlas_from_template}{}}}
\subsection{Method \code{generate_atlas_from_template()}}{
Generate atlas maps from template and morph to native brain
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$generate_atlas_from_template(
  template_name = rpyants_builtin_templates(),
  atlas_folder = NULL,
  surfaces = NA,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{template_name}}{which template to use}

\item{\code{atlas_folder}}{path to the atlas folder (that contains the atlas
files)}

\item{\code{surfaces}}{whether to generate surfaces (triangle mesh); default is
\code{NA} (generate if not existed). Other choices are \code{TRUE}
for always generating and overwriting surface files, or \code{FALSE}
to disable this function. The generated surfaces will stay in native
\code{'T1'} space.}

\item{\code{verbose}}{whether the print out the progress}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-transform_points_to_template"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-transform_points_to_template}{}}}
\subsection{Method \code{transform_points_to_template()}}{
Transform points from native images to template
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$transform_points_to_template(
  native_ras,
  template_name = rpyants_builtin_templates(),
  native_type = "T1w",
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{native_ras}}{matrix or data frame with 3 columns indicating points
sitting on native images in right-anterior-superior (\code{'RAS'})
coordinate system.}

\item{\code{template_name}}{template to use for mapping}

\item{\code{native_type}}{native image type where the points sit on}

\item{\code{verbose}}{whether the print out the progress}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-transform_points_from_template"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-transform_points_from_template}{}}}
\subsection{Method \code{transform_points_from_template()}}{
Transform points from template images to native
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$transform_points_from_template(
  template_ras,
  template_name = rpyants_builtin_templates(),
  native_type = "T1w",
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{template_ras}}{matrix or data frame with 3 columns indicating points
sitting on template images in right-anterior-superior (\code{'RAS'})
coordinate system.}

\item{\code{template_name}}{template to use for mapping}

\item{\code{native_type}}{native image type where the points sit on}

\item{\code{verbose}}{whether the print out the progress}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-construct_ants_folder_from_template"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-construct_ants_folder_from_template}{}}}
\subsection{Method \code{construct_ants_folder_from_template()}}{
Create a reconstruction folder (as an alternative option) that
is generated from template brain to facilitate the three-dimensional
viewer. Please make sure method \code{map_to_template} is called before
using this method (or the program will fail)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$construct_ants_folder_from_template(
  template_name = rpyants_builtin_templates(),
  add_surfaces = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{template_name}}{template to use for mapping}

\item{\code{add_surfaces}}{whether to create surfaces that is morphed from
template to local; default is \code{TRUE}. Please enable this option
only if the cortical surfaces are not critical (for example,
you are studying the deep brain structures). Always use
\code{'FreeSurfer'} if cortical information is used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-get_brain"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-get_brain}{}}}
\subsection{Method \code{get_brain()}}{
Get three-dimensional brain model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$get_brain(
  electrodes = TRUE,
  coord_sys = c("scannerRAS", "tkrRAS", "MNI152", "MNI305"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{electrodes}}{whether to add electrodes to the viewers; can be
logical, data frame, or a character (path to electrode table). When
the value is \code{TRUE}, the electrode file under \code{project_name}
will be loaded; when \code{electrodes} is a \code{\link{data.frame}},
or path to a \code{'csv'} file, then please specify \code{coord_sys}
on what is the coordinate system used for columns \code{"x"}, \code{"y"},
and \code{"z"}.}

\item{\code{coord_sys}}{coordinate system if \code{electrodes} is a data frame
with columns \code{"x"}, \code{"y"}, and \code{"z"}, available choices
are \code{'scannerRAS'} (defined by 'T1' weighted native 'MRI' image),
\code{'tkrRAS'} (\code{'FreeSurfer'} defined native 'TK-registered'),
\code{'MNI152'} (template 'MNI' coordinate system averaged over 152
subjects; this is the common "'MNI' coordinate space" we often refer to),
and \code{'MNI305'} (template 'MNI' coordinate system averaged over 305
subjects; this coordinate system used by templates such as
\code{'fsaverage'})}

\item{\code{...}}{passed to \code{\link[threeBrain]{threeBrain}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-YAELProcess-clone"></a>}}
\if{latex}{\out{\hypertarget{method-YAELProcess-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAELProcess$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
