% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_pdf.R
\name{raster_pdf}
\alias{raster_pdf}
\alias{agg_pdf}
\title{Raster PDF graphics device (with PNG pages)}
\usage{
raster_pdf(
  filename = "Rplots.pdf",
  width = NULL,
  height = NULL,
  units = NULL,
  res = NULL,
  png_function = NULL,
  pdf_function = NULL,
  ...
)

agg_pdf(...)
}
\arguments{
\item{filename}{A character string of the output file name.}

\item{width}{Page width. If \code{NULL}, use value of
\code{getOption("rasterpdf.width")} if set, and default to \code{7} otherwise.}

\item{height}{Page height. If \code{NULL}, use value of
\code{getOption("rasterpdf.height")} if set, and default to \code{7} otherwise.}

\item{units}{The units in which \code{height} and \code{weight} are given. Can be
\code{"in"} (inches), \code{"cm"}, \code{"mm"}, or \code{"px"} (pixels). If \code{NULL}, use
value of \code{getOption("rasterpdf.units")} if set, and default to "in"
` otherwise.}

\item{res}{Resolution in ppi. If \code{NULL}, use value of
\code{getOption("rasterpdf.res")} if set, and default to \code{72L} otherwise.}

\item{png_function}{A PNG device function. If \code{NULL}, use \code{\link[grDevices:png]{grDevices::png()}}.}

\item{pdf_function}{A PDF device function. If \code{NULL}, use
\code{\link[grDevices:cairo_pdf]{grDevices::cairo_pdf()}} if it is available, and \code{\link[grDevices:png]{grDevices::png()}}
otherwise.}

\item{...}{Further arguments passed through to the PNG device function
specified in \code{png_function}.}
}
\description{
Open a graphics device for raster PDF files. Internally, a PNG device is
used for the individual pages, which are then combined into one PDF file.
}
\details{
The ability to plot raster graphics in PDF files can be useful when one needs
multipage documents, but the plots contain so many individual elements that
use of vector graphics (with \code{\link[grDevices:pdf]{grDevices::pdf()}}) results in inconveniently
large file sizes

Internally, the function plots each individual page in a PNG file, which are
then combined into one PDF file when \code{\link[=dev.off]{dev.off()}} is called. By default, the
PNGs are generated with \code{\link[grDevices:png]{grDevices::png()}}, but another device function can
also be specified. The PDF is by default generated with
\code{\link[grDevices:cairo_pdf]{grDevices::cairo_pdf()}} if it is available, and
\code{\link[grDevices:pdf]{grDevices::pdf()}} otherwise. Again, it is possible to specify another PDF
device function.

\code{agg_pdf(...)} is shorthand for
\code{raster_pdf(..., png_function = ragg::agg_png)}.
}
\examples{
raster_pdf(tempfile(fileext = ".pdf"))
plot(iris)
dev.off()

}
\seealso{
\code{\link[grDevices:pdf]{grDevices::pdf()}}, \code{\link[grDevices:cairo_pdf]{grDevices::cairo_pdf()}},
\code{\link[grDevices:png]{grDevices::png()}}, \code{\link[ragg:agg_png]{ragg::agg_png()}}
}
