% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sccs_size.R
\name{sccs_size}
\alias{sccs_size}
\title{Sample Size or Power for Self-Controlled Case Series (SCCS)}
\usage{
sccs_size(p, r, alpha, beta = NULL, n = NULL)
}
\arguments{
\item{p}{Numeric. True relative incidence (risk period vs baseline).}

\item{r}{Numeric. Proportion of observation time that is risk period.}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate. Required for sample size calculation.}

\item{n}{Integer (optional). Sample size. Required for power calculation.}
}
\value{
Numeric. Returns sample size (if \code{beta} is given), or power (if \code{n} is given).
}
\description{
Calculates sample size or power for self-controlled case series studies.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{n} (for power calculation) should be specified.

Required arguments:
\itemize{
\item For sample size: \code{p}, \code{r}, \code{alpha}, \code{beta}
\item For power: \code{p}, \code{r}, \code{alpha}, \code{n}
}
}
\examples{
# Sample size
sccs_size(p = 3, r = 42/365,
          alpha = 0.05, beta = 0.2)

# Power
sccs_size(p = 3, r = 42/365,
          alpha = 0.05, n = 54)

}
