% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metrics.R
\name{GetMetrics}
\alias{GetMetrics}
\title{Get treatment ranking metrics from network meta-analysis output}
\usage{
GetMetrics(
  data,
  outcome = NULL,
  prefer = NULL,
  metrics = NULL,
  model = "random",
  simt = 1000,
  rob = NULL
)
}
\arguments{
\item{data}{DATA of \emph{netmeta} output.}

\item{outcome}{STRING for name of outcome.}

\item{prefer}{STRING for indicating which direction is beneficial treatment
effect in terms of "small" and "large" values in statistic test.}

\item{metrics}{STRING for metrics of treatment ranking in terms of "SUCRA",
"P-score", and "P-best" for the value of surface under the
cumulative ranking curve, P-score, and probability of achieving
the best treatment.}

\item{model}{STRING for analysis model in terms of "random" and "common" for
random-effects model and common-effect model.}

\item{simt}{INTEGER for times of simulations to estimate surface under the
cumulative ranking curve (SUCRA).}

\item{rob}{STRING for column name of risk of bias.}
}
\value{
\strong{GetMetrics()} returns a data.frame with three columns, including
treatment, metrics of treatment ranking, and outcome name.
}
\description{
\strong{GetMetrics()} is a function for gathering metrics of treatment ranking
from \emph{netmeta} output.
}
\examples{
## Not run:
#library(netmeta)
#data(Senn2013)
#nma <- netmeta(TE, seTE, treat1, treat2,
#studlab, data = Senn2013, sm = "SMD")

# Get SUCRA
#dataMetrics <- GetMetrics(nma, outcome = "HbA1c", prefer = "small",
#metrics = "SUCRA", model = "random", simt = 1000)

# Get P-score
#dataMetrics <- GetMetrics(nma, outcome = "HbA1c", prefer = "small",
#metrics = "P-score", model = "random", simt = 1000)
## End(Not run)

}
\references{
Rücker, G., & Schwarzer, G. (2015). Ranking treatments in frequentist
network meta-analysis works without resampling methods.
\strong{BMC medical research methodology}, \emph{15(1)}, 1-9.

Salanti, G., Ades, A. E., & Ioannidis, J. P. (2011). Graphical methods and
numerical summaries for presenting results from multiple-treatment
meta-analysis: an overview and tutorial. \strong{Journal of clinical epidemiology},
\emph{64(2)}, 163-171.
}
\seealso{
\code{\link{SetMetrics}}
}
