% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder.R
\name{reorder_by_priority}
\alias{reorder_by_priority}
\title{Bring specified values in a vector to the front}
\usage{
reorder_by_priority(x, priority_values)
}
\arguments{
\item{x}{A character or numeric vector to reorder.}

\item{priority_values}{A vector of “priority” values. Elements of \code{x} that match
entries in \code{priority_values} are moved to the front in the order they appear in
\code{priority_values}. Values not found in \code{x} are ignored.}
}
\value{
A reordered vector with priority values first, followed by all
remaining elements in their original order.
}
\description{
Reorders a vector so that any elements matching the values in \code{values}
appear first, in the order they appear in \code{values}. All remaining elements
are returned afterward, preserving their original order.
}
\examples{
reorder_by_priority(c("A", "B", "C", "D", "E"), c("C", "A"))
reorder_by_priority(1:6, c(4, 2, 7))

}
