% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.sim_results.R
\name{subset.sim_results}
\alias{subset.sim_results}
\title{Subset of Given Time Points from \code{sim_results} Object}
\usage{
\method{subset}{sim_results}(x, from = NULL, time_points = NULL, ...)
}
\arguments{
\item{x}{\code{sim_results} object; returned by the \code{\link{sim}} function}

\item{from}{numeric vector of length 1; indicates the starting time point
from which all time point should be kept}

\item{time_points}{numeric vector; indicates all time points to keep}

\item{...}{further arguments to be passed to or from other methods}
}
\value{
\code{sim_results} object with only selected \code{time_points} present
in the \code{N_map} slot
}
\description{
This function creates a subset of given time points from the \code{sim_results} object.
}
\details{
Either \code{from} or \code{time_points} argument has to be specified.
Time point passed by the \code{from} argument will be set as a cutoff point
and all abundances for previous time points will be discarded.
}
\examples{
# data preparation
library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data <- initialise(
  n = n1_small,
  r = log(2),
  K_map = K_small,
  max_dist = 1000,
  rate = 1 / 1e3
)

sim_results <- sim(sim_data, time = 10)
summary(sim_results)

sim_results_cropped <- subset(sim_results, time_points = c(1:2))
summary(sim_results_cropped)


}
