% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_extension_distributions.R
\name{r_letters}
\alias{r_letters}
\alias{r_LETTERS}
\alias{r_Letters}
\title{Generate Random Letters}
\usage{
r_letters(nchar = 1, ..., n = default_n(nchar), .seed = NULL)

r_LETTERS(nchar = 1, ..., n = default_n(nchar), .seed = NULL)

r_Letters(nchar = 1, ..., n = default_n(nchar), .seed = NULL)
}
\arguments{
\item{nchar}{vector of number of characters to return, positive integer}

\item{...}{Unused}

\item{n}{number of observations to generate. The \code{\link[=default_n]{default_n()}} function will
provide a default value within context}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A character vector of length \code{n}
}
\description{
Generates a set of Random Letters.
}
\section{Functions}{
\itemize{
\item \code{r_letters}: Uses only lower-case letters

\item \code{r_LETTERS}: Uses only upper-case letters

\item \code{r_Letters}: Uses lower- & upper-case letters
}}

\examples{

set_n(5)

r_letters(3)

r_letters(1:10)

r_letters(3, n = 10)

r_LETTERS(3)

r_LETTERS(1:10)

r_LETTERS(3, n = 10)

r_Letters(3)

r_Letters(1:10)

r_Letters(3, n = 10)
}
