% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{match.call2}
\alias{match.call2}
\title{Alternate Parametrisation of \code{match.call()}}
\usage{
match.call2(
  n = 0L,
  definition = sys.function(sys.parent(n + 1L)),
  call = sys.call(sys.parent(n + 1L)),
  expand.dots = TRUE,
  envir = parent.frame(n + 3L)
)
}
\arguments{
\item{n}{How far up the call-stack they would like to extract. The default,
\code{n=0} produces the same result as \code{match.call()} so this can be
inserted wherever \code{match.call()} is used.}

\item{definition}{a function, by default the function from which
\code{match.call2()} is called.}

\item{call}{an unevaluated call to the function specified by
\code{definition}, as generated by \code{call}}

\item{expand.dots}{logical. Should arguments matching \code{...} in the
call be included or left as a \code{...} argument?}

\item{envir}{an environment, from which the \code{...} in \code{call}
are retrieved, if any.}
}
\value{
An object of class \code{call}
}
\description{
Alters the built-in function \code{\link[=match.call]{match.call()}} by providing an
additional argument which means that by default a user can specify
how far up the call stack they want to match a call of. See
\link[base:match.call]{match.call()} for more details.
}
\examples{
f <- function(n) {
  g(n)
}

g <- function(n) {
  h(n)
}

h <- function(n) {
  match.call2(n)
}

f(0)
f(1)
f(2)
}
