% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothconv.R
\name{smoothconv}
\alias{smoothconv}
\title{Smoothening using convolution with a circular kernel}
\usage{
smoothconv(z, nas)
}
\arguments{
\item{z}{matrix with the input field to smoothen, with dimensions \code{c(ns, ns)}}

\item{nas}{the smoothing kernel uses a radius \code{(ns/nas)/2}}
}
\value{
The smoothened field.
}
\description{
The input field is convolved with a circular kernel with equal
weights. Takes into account missing values.
}
\examples{
z <- rnorm(64 * 64)
dim(z) <- c(64, 64)
zs <- smoothconv(z, 8)
sd(zs)
# [1] 0.07910996
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
