% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainfarm.R
\name{rainfarm}
\alias{rainfarm}
\title{Perform RainFARM downscaling}
\usage{
rainfarm(r, slope, nf, weights = 1, fglob = FALSE, fsmooth = TRUE,
  verbose = FALSE)
}
\arguments{
\item{r}{matrix or array with large-scale field to downscale. Can be a
three-dimensional array with multiple frames at different times.
Spatial downscaling is performed separately for each element of the
third dimension of \code{r}.}

\item{slope}{spatial spectral slope.}

\item{nf}{refinement factor for spatial downscaling.}

\item{weights}{matrix with weights for orographic downscaling generated
by the \code{\link[=rfweights]{rfweights()}} function.}

\item{fglob}{logical to conserve global average over domain.}

\item{fsmooth}{logical to use smoothing for conservation.
If neither \code{fsmooth} or \code{fglob} is set precipitation is conserved over
each coarse pixel of the input field.}

\item{verbose}{logical to provide some progress report.}
}
\value{
The downscaled array.
}
\description{
The input array is downscaled to finer spatial resolution
using the RainFARM stochastic precipitation downscaling method.
Orographic correction weights can be applied as described in
Terzago et al. (2018) \doi{10.5194/nhess-18-2825-2018}.
Precipitation can be conserved globally (\code{fglob}), using convolution
(\code{fsmooth}) or over the original coarse-scale boxes.
}
\examples{
# Make some sample synthetic rainfall data
r <- exp(rnorm(4 * 4 * 10))
dim(r) <- c(4, 4, 10)
r[ , , 1]
#           [,1]      [,2]      [,3]      [,4]
# [1,] 1.8459816 1.8536550 2.1600665 1.3102116
# [2,] 1.3851011 1.4647348 0.2708219 0.4571810
# [3,] 0.2492451 0.8227134 0.4790567 1.9320403
# [4,] 0.5985922 3.3065678 2.1282795 0.6849944
# Downscale with spectral slope=1.7 to size 32x32
rd <- rainfarm(r, 1.7, 8, fsmooth=FALSE) 
# Verify that downscaled data maintained original box averages
agg(rd[ , , 1], 4) 
#           [,1]      [,2]      [,3]      [,4]
# [1,] 1.8459816 1.8536550 2.1600665 1.3102116
# [2,] 1.3851011 1.4647348 0.2708219 0.4571810
# [3,] 0.2492451 0.8227134 0.4790567 1.9320403
# [4,] 0.5985922 3.3065678 2.1282795 0.6849944
}
\references{
Terzago, S. et al. (2018). NHESS 18(11), 2825–2840
\doi{10.5194/nhess-18-2825-2018}; D'Onofrio et al. (2014).
J of Hydrometeorology 15, 830-843 \doi{10.1175/JHM-D-13-096.1};
Rebora et. al. (2006), JHM 7, 724 \doi{10.1175/JHM517.1}.
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
