% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{rainette_stats}
\alias{rainette_stats}
\title{Generate cluster keyness statistics from a rainette result}
\usage{
rainette_stats(
  groups,
  dtm,
  measure = c("chi2", "lr", "frequency", "docprop"),
  n_terms = 15,
  show_negative = TRUE,
  max_p = 0.05
)
}
\arguments{
\item{groups}{groups membership computed by \code{cutree_rainette} or \code{cutree_rainette2}}

\item{dtm}{the dfm object used to compute the clustering}

\item{measure}{statistics to compute}

\item{n_terms}{number of terms to display in keyness plots}

\item{show_negative}{if TRUE, show negative keyness features}

\item{max_p}{maximum keyness statistic p-value}
}
\value{
A list with, for each group, a data.frame of keyness statistics for the most specific
n_terms features.
}
\description{
Generate cluster keyness statistics from a rainette result
}
\examples{
\donttest{
require(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
tok <- tokens(corpus, remove_punct = TRUE)
tok <- tokens_remove(tok, stopwords("en"))
dtm <- dfm(tok, tolower = TRUE)
dtm <- dfm_trim(dtm, min_docfreq = 3)
res <- rainette(dtm, k = 3, min_segment_size = 15)
groups <- cutree_rainette(res, k = 3)
rainette_stats(groups, dtm)
}
}
\seealso{
\code{\link[quanteda.textstats:textstat_keyness]{quanteda.textstats::textstat_keyness()}}, \code{\link[=rainette_explor]{rainette_explor()}}, \code{\link[=rainette_plot]{rainette_plot()}}
}
