% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_naive.R
\name{naive}
\alias{naive}
\title{Simple Linear Models for Rating and Ranking}
\usage{
naive(jpMat, stats = FALSE, ties.method = "average")
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{stats}{a logical value to indicate whether a linear model should be fitted and the test statistics should be reported}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\description{
Calculate ratings and provide rankings using Simple Linear regression
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),
nrow=6,
byrow=TRUE)
result <- naive(jpMat)
print(result)
}
\references{
Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.
}
\author{
Jiangtao Gou

Shuyi Wu
}
