% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linesink.R
\name{headlinesink}
\alias{headlinesink}
\title{Create a head-specified line-sink analytic element}
\usage{
headlinesink(x0, y0, x1, y1, hc, resistance = 0, width = 0, ...)
}
\arguments{
\item{x0}{numeric, starting x location of line-sink.}

\item{y0}{numeric, starting y location of line-sink.}

\item{x1}{numeric, ending x location of line-sink.}

\item{y1}{numeric, ending y location of line-sink.}

\item{hc}{numeric, specified hydraulic head of the line-sink.}

\item{resistance}{numeric, hydraulic resistance of the line-sink at its connection with the aquifer. Defaults to 0 (no resistance).}

\item{width}{numeric, width of the line-sink. Used with \code{resistance} to calculate the line-sink strength, and by \code{\link[=tracelines]{tracelines()}} to
determine if a particle has reached the line. Defaults to zero (infinitesimally narrow line).}

\item{...}{ignored}
}
\value{
Head-specified line-sink analytic element which is an object of class \code{headlinesink} and inherits from \code{linesink}.
}
\description{
\code{\link[=headlinesink]{headlinesink()}} creates a line-sink analytic element with constant specified head. The discharge
into the line-sink per unit length is computed by solving the corresponding \code{aem} model.
}
\details{
The strength of the line-sink (discharge per unit length of line-sink) is computed by solving
the \code{aem} model given the specified head \code{hc} for the line-sink. This head is located at the so-called
collocation point, which is placed at the center of the line-sink.

The resistance can be increased for a line-sink in poor connection with the aquifer. The effect of a larger
or smaller wetted perimeter can be mimicked by adjusting the \code{resistance} and/or \code{width} accordingly. If
\code{width = 0} (the default) it is removed from the conductance calculation. If the aquifer is unconfined
(i.e. has a variable saturated thickness), the system of equations becomes non-linear with respect to the
hydraulic head and iteration is required to solve the model.
}
\examples{
hls <- headlinesink(-75, 50, 100, 50, hc = 10)
hls <- headlinesink(-75, 50, 100, 50, hc = 10, resistance = 10, width = 4)

}
\seealso{
\code{\link[=linesink]{linesink()}}
}
