% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{element_discharge}
\alias{element_discharge}
\title{Get the computed discharge from an element}
\usage{
element_discharge(aem, name = NULL, type = NULL, ...)
}
\arguments{
\item{aem}{\code{aem} object.}

\item{name}{character vector with the name of the element(s) as available in \code{aem$elements}.}

\item{type}{character with the type (class) of element to obtain the summed discharge from. See details.}

\item{...}{ignored}
}
\value{
A numeric named vector of length \code{length(name)} with the discharge into (negative) or out of (positive)
the aquifer. If \code{type} is specified, a single named numeric value with the total discharge into (negative) or
out of (positive) the aquifer which is the sum of all individual elements of class \code{type}.
}
\description{
\code{\link[=element_discharge]{element_discharge()}} obtains the computed discharge into or out of the aquifer
for a individual analytic element or all elements of a given type.
}
\details{
Either \code{name} or \code{type} should be specified. If \code{type} is specified, only one type is allowed.
Possible values are \verb{'headwell', 'well', 'linesink', 'headlinesink', 'areasink'} or \code{'headareasink'}.

Only elements that add or remove water from the aquifer will return a non-zero discharge value.
}
\examples{
k <- 10
top <- 10
base <- 0
n <- 0.2
TR <- k * (top - base)

rf <- constant(xc = -500, yc = 0, h = 20)
uf <- uniformflow(gradient = 0.002, angle = -45, TR = TR)
w1 <- well(xw = 50, yw = 0, Q = 200)
w2 <- well(xw = 0, yw = 100, Q = 400)
hw <- headwell(xw = -100, yw = 0, hc = 7.5)
hls <- headlinesink(x0 = -200, y0 = -150, x1 = 200, y1 = 150, hc = 8)
as <- areasink(xc = 0, yc = 0, N = 0.0005, R = 500)
m <- aem(k, top, base, n, rf, uf, w1, w2, hw, hls, as)

element_discharge(m, name = c('hls', 'as'))
element_discharge(m, type = 'well')

# zero discharge for uniform flow element as it does not add or remove water
element_discharge(m, name = 'uf')
}
