% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnp_sdef_erg_hist.R
\name{mcnp_sdef_erg_hist}
\alias{mcnp_sdef_erg_hist}
\title{energy distribution histogram from pasted data}
\usage{
mcnp_sdef_erg_hist(
  entry_mode = "scan",
  my_dir = NULL,
  E_MeV = NULL,
  bin_prob = NULL,
  write_permit = "n",
  log_plot = 0
)
}
\arguments{
\item{entry_mode}{How do you want to enter the data? Default is "scan", allowing you to copy and paste data in at prompts. The other option is "read". In read mode, you identify the data that is already loaded in R.}

\item{my_dir}{Optional directory. The function will write to the working directory by default.}

\item{E_MeV}{Energy bin levels in MeV.}

\item{bin_prob}{Relative probability of bin energy.}

\item{write_permit}{Set this to 'y' to allow writing output to your directory.}

\item{log_plot}{0 = no log axes (default), 1  = log y-axis, 2 = log both axes.}
}
\value{
A vector of energy bins and probabilities for an energy distribution, formatted as needed for MCNP input. It is designed for copying and pasting into an MCNP input.
}
\description{
energy distribution histogram from pasted data
}
\details{
The output includes si# and sp#. The # should be changed to the appropriate distribution number. The data is saved in the global environment and appended to a file in the user's working directory, si_sp.txt. Two plots of the data are provided to the plot window,  one with two linear axes and one with two log axes.
}
\examples{
\dontrun{
mcnp_sdef_erg_hist()
}
}
\seealso{
\code{\link[=mcnp_sdef_erg_line]{mcnp_sdef_erg_line()}} for data from \code{RadData}

Other mcnp tools: 
\code{\link{mcnp_cone_angle}()},
\code{\link{mcnp_est_nps}()},
\code{\link{mcnp_matrix_rotations}()},
\code{\link{mcnp_mesh_bins}()},
\code{\link{mcnp_plot_out_spec}()},
\code{\link{mcnp_scan2plot}()},
\code{\link{mcnp_scan_save}()},
\code{\link{mcnp_sdef_erg_line}()},
\code{\link{mcnp_si_sp_RD}()},
\code{\link{mcnp_si_sp_hist_scan}()},
\code{\link{mcnp_si_sp_hist}()}
}
\concept{mcnp tools}
