% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racircalbatch.R
\name{racircalbatch}
\alias{racircalbatch}
\title{Corrects a batch of rapid A/Ci response (RACiR) data}
\usage{
racircalbatch(
  caldata,
  data,
  mincut,
  maxcut,
  title,
  varnames = list(A = "A", Ca = "Ca", CO2_r = "CO2_r", E = "E", gtc = "gtc")
)
}
\arguments{
\item{caldata}{Data frame with the calibration data}

\item{data}{List of data frames with the RACiR response data}

\item{mincut}{Minimum cutoff value for reference CO2 (CO2_r). Used to cut
out the data from the initial chamber mixing. Default value is set to the
minimum COR_r value.}

\item{maxcut}{Maximum cutoff value for reference CO2 (CO2_r). Used to cut
out the data from the end of the response. Not needed in all cases. Default
value is set to the maximum COR_r value.}

\item{title}{Vector for titles of output graph - useful for batch RACiR
corrections. Length must be equal to data list length}

\item{varnames}{Variable names - this allows for the use of this code with
other machines and setups where variable names may differ.}
}
\value{
racircalbatch calibrates a batch of RACiR data
}
\description{
\code{racircalbatch} Corrects your RACiR data files based on a calibration file.
Produces diagnostic graphs of A vs. Ci for quality control. Output
includes a list of data frames with corrected data.
}
\examples{
\donttest{
#Create a list of files
files <- c(system.file("extdata", "poplar_1", package = "racir"),
          system.file("extdata", "poplar_2", package = "racir"))
data <- vector("list", length(files))
for(i in seq_along(files)){
 data[[i]] <- read_6800(files[i])
 names(data)[i] <- files[i]
}

caldata <- read_6800(system.file("extdata", "cal", package = "racir"))
output <- racircalbatch(caldata = caldata, data = data,
                       mincut = 300, maxcut = 780, title = files)
}

}
