% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcvp_match_names.R
\name{wcvp_match_names}
\alias{wcvp_match_names}
\title{Match names to the WCVP.}
\usage{
wcvp_match_names(
  names_df,
  wcvp_names = NULL,
  name_col = NULL,
  id_col = NULL,
  author_col = NULL,
  join_cols = NULL,
  fuzzy = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{names_df}{Data frame of names for matching.}

\item{wcvp_names}{Data frame of taxonomic names from WCVP version 7 or later.
If \code{NULL} (the default), names will be loaded from \href{https://matildabrown.github.io/rWCVPdata/}{\code{rWCVPdata::wcvp_names}}.}

\item{name_col}{Character. The column in \code{names_df} that has the taxon name
for matching.}

\item{id_col}{Character. A column in \code{names_df} with a unique ID for each
name. Will be created from the row number if not provided.}

\item{author_col}{the column in \code{names_df} that has the name authority, to aid
matching. Set to \code{NULL} to match with no author string.}

\item{join_cols}{Character. A vector of name parts to make the taxon name,
if \code{name_col} is not provided.}

\item{fuzzy}{Logical; whether or not fuzzy matching should be used for names
that could not be matched exactly.}

\item{progress_bar}{Logical. Show progress bar when matching? Defaults to
\code{TRUE}; should be changed to \code{FALSE} if used in a markdown report.}
}
\value{
Match results from WCVP bound to the original data from \code{names_df}.
}
\description{
Match names to WCVP, first using exact matching and then using fuzzy matching
on any remaining unmatched names.
}
\details{
By default, exact matching uses only the taxon name (supplied by \code{name_col})
unless a column specifying the author string is provided (as \code{author_col}).

Columns setting out name parts can be supplied as \code{join_cols} in place of a
taxon name, but must be supplied in the order you want them joined
(e.g. \code{c("genus", "species", "infra_rank", "infra")}).

Fuzzy matching uses a combination of phonetic and edit distance matching,
and can optionally be turned off using \code{fuzzy=FALSE}.

The WCVP can be loaded for matching from \href{https://matildabrown.github.io/rWCVPdata/}{\code{rWCVPdata::wcvp_names}}.

See \href{https://matildabrown.github.io/rWCVP/articles/redlist-name-matching.html}{here} for an example workflow.
}
\examples{
\donttest{ # these examples require 'rWCVPdata'
if(requireNamespace("rWCVPdata")){
wcvp_names <- rWCVPdata::wcvp_names

# without author
wcvp_match_names(redlist_example, wcvp_names,
  name_col = "scientificName",
  id_col = "assessmentId"
)

# with author
wcvp_match_names(redlist_example, wcvp_names,
  name_col = "scientificName",
  id_col = "assessmentId", author_col = "authority"
)
}
}

}
\seealso{
Other name matching functions: 
\code{\link{wcvp_match_exact}()},
\code{\link{wcvp_match_fuzzy}()}
}
\concept{name matching functions}
