% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_cylinders.R
\name{update_cylinders}
\alias{update_cylinders}
\title{Update Cylinders}
\usage{
update_cylinders(cylinder)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}
}
\value{
Returns a data frame
}
\description{
Updates the QSM cylinder data in preparation for radii correction
}
\details{
Updates and verifies parent-child cylinder relationships and
calculates new variables and metrics found throughout the supported QSM
software. \code{update_cylinders()} is required to run all rTwig functions, and
is run automatically if rTwig detects a new QSM.
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_treeqsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)
str(cylinder)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- update_cylinders(cylinder)
str(cylinder)

## aRchi Processing Chain
file <- system.file("extdata/QSM2.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- update_cylinders(cylinder)
str(cylinder)

}
\references{
\insertRef{growth_parameter1}{rTwig}

\insertRef{growth_parameter2}{rTwig}
}
