% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bacteria_tpc}
\alias{bacteria_tpc}
\title{Example thermal performance curves of bacterial growth}
\format{
A data frame with 649 rows and 7 variables:
\describe{
  \item{phage}{whether the bacteria was grown with or without phage}
  \item{temp}{the assay temperature at which the growth rate was measured (degrees centigrade)}
  \item{rate}{estimated growth rate per hour}
}
}
\source{
Daniel Padfield
}
\usage{
data("bacteria_tpc")
}
\description{
A dataset containing example data of growth rates of the bacteria Pseudomonas fluorescens in the presence and absence of its phage, phi2. Growth rates were measured across a range of assay temperatures to incorporate the entire thermal performance of the bacteria The dataset is the cleaned version so some data points have been omitted. There are multiple independent measurements per temperature for each treatment.
}
\examples{
data("bacteria_tpc")
library(ggplot2)
ggplot(bacteria_tpc) +
 geom_point(aes(temp, rate, col = phage))
}
\references{
Padfield, D., Castledine, M., & Buckling, A. (2020). Temperature-dependent changes to host–parasite interactions alter the thermal performance of a bacterial host. The ISME Journal, 14(2), 389-398.
}
\keyword{dataset}
